<?php
require 'db.php';

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Get the posted data
$data = json_decode(file_get_contents("php://input"), true);

// Check if all required fields are present
if (
    isset($data['session_name']) && 
    isset($data['session_type']) && 
    isset($data['include_iec_activity']) && 
    isset($data['batch_type']) && 
    isset($data['batch_frequency']) && 
    isset($data['time_slot']) && 
    isset($data['session_date']) && 
    isset($data['session_venue'])
) {
    $session_name = $data['session_name'];
    $session_type = $data['session_type'];
    $include_iec_activity = $data['include_iec_activity'] ? 1 : 0;
    $batch_type = $data['batch_type'];
    $batch_frequency = $data['batch_frequency'];
    $time_slot = $data['time_slot'];
    $session_status = 'pending'; // Default session status
    $session_date = $data['session_date'];
    $mobile_number = $data['mobile_number'];
    $session_venue = $data['session_venue'];
    // $asanas = json_encode($data['asanas']); // Ensure asanas is properly encoded

    // Fetch yoga_instructor_id based on mobile_number
    $stmt = $conn->prepare("SELECT id FROM yoga_instructors WHERE mobile_number = ?");
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Database error']);
        exit;
    }
    
    $stmt->bind_param("s", $mobile_number);
    $stmt->execute();
    $result = $stmt->get_result();
    $instructor = $result->fetch_assoc();
    $stmt->close();

    if (!$instructor) {
        echo json_encode(['status' => 'error', 'message' => 'Instructor not found']);
        exit;
    }

    $yoga_instructor_id = $instructor['id'];

    // Use prepared statements to prevent SQL injection
    $stmt = $conn->prepare("INSERT INTO yog_sessions (session_name, session_type, include_iec_activity, batch_type, batch_frequency, time_slot, session_status, session_venue, session_date, yoga_instructor_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssssss", $session_name, $session_type, $include_iec_activity, $batch_type, $batch_frequency, $time_slot, $session_status, $session_venue, $session_date, $yoga_instructor_id);

    if ($stmt->execute()) {
        http_response_code(201);
        echo json_encode(["status" => "success", "message" => "Session created successfully"]);
    } else {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error: " . $stmt->error]);
    }

    $stmt->close();
} else {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Invalid input"]);
}

$conn->close();
?>
