<?php
require 'db.php';

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['mobile'])) {
    $mobile = $_GET['mobile'];

    // Fetch instructor details based on mobile number
    $stmt = $conn->prepare("SELECT id, district, ayush_hwc, instructor_name FROM yoga_instructors WHERE mobile_number = ?");
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Database error']);
        exit;
    }

    $stmt->bind_param("s", $mobile);
    $stmt->execute();
    $result = $stmt->get_result();
    $instructor = $result->fetch_assoc();
    $stmt->close();

    if ($instructor) {
        echo json_encode(['status' => 'success', 'instructor' => $instructor]);
    } else {
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'Instructor not found']);
    }
} else {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
}

$conn->close();
?>
