<?php
require 'db.php';

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

$input = json_decode(file_get_contents("php://input"), true);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $sessionName = $input['session_name'];
    $sessionDate = $input['session_date'];
    $district = $input['district'];
    $ayushHwc = $input['ayush_hwc'];
    $sessionType = $input['session_type'];
    $includeIecActivity = $input['include_iec_activity'] ? 1 : 0; // Store as integer
    $batchType = $input['batch_type'];
    $batchFrequency = $input['batch_frequency'];
    $timeSlot = $input['time_slot'];
    $asanas = json_encode($input['asanas']);
    $participantNumber = $input['participant_number'];
    $sessionStatus = $input['session_status'];

    $sql = "INSERT INTO yog_sessions (session_name, session_date, district, ayush_hwc, session_type, include_iec_activity, batch_type, batch_frequency, time_slot, asanas, participant_number, session_status) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param('sssssisissis', $sessionName, $sessionDate, $district, $ayushHwc, $sessionType, $includeIecActivity, $batchType, $batchFrequency, $timeSlot, $asanas, $participantNumber, $sessionStatus);

    if ($stmt->execute()) {
        http_response_code(201);
        echo json_encode(["message" => "Session created successfully"]);
    } else {
        http_response_code(500);
        echo json_encode(["message" => "Error creating session: " . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
    exit();
}

$sql = "SELECT s.id, s.session_name, s.time_slot, s.created_at, s.session_status, s.session_type, s.ayush_hwc, s.include_iec_activity, s.participant_number, s.session_date, 
               GROUP_CONCAT(p.name) as participant_names, 
               GROUP_CONCAT(p.mobile) as participant_mobiles, 
               GROUP_CONCAT(p.age) as participant_ages, 
               GROUP_CONCAT(p.gender) as participant_genders 
        FROM yog_sessions s 
        LEFT JOIN participants p ON s.id = p.session_id 
        GROUP BY s.id";
$result = $conn->query($sql);

$sessions = array();

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $row['include_iec_activity'] = $row['include_iec_activity'] ? 'Yes' : 'No';
        $row['participants'] = [];
        
        if ($row['participant_names']) {
            $names = explode(',', $row['participant_names']);
            $mobiles = explode(',', $row['participant_mobiles']);
            $ages = explode(',', $row['participant_ages']);
            $genders = explode(',', $row['participant_genders']);
            
            for ($i = 0; $i < count($names); $i++) {
                $row['participants'][] = [
                    'name' => $names[$i],
                    'mobile' => $mobiles[$i],
                    'age' => $ages[$i],
                    'gender' => $genders[$i]
                ];
            }
        }
        
        unset($row['participant_names']);
        unset($row['participant_mobiles']);
        unset($row['participant_ages']);
        unset($row['participant_genders']);
        
        $sessions[] = $row;
    }
}

echo json_encode($sessions);

$conn->close();
?>
