<?php
require 'db.php';

header('Content-Type: application/json');

// Check if district parameter is set
if (isset($_GET['district'])) {
    $district = mysqli_real_escape_string($conn, $_GET['district']);
    $query = "SELECT ayush_hwc FROM yoga_instructors WHERE district='$district'";
    $error_message = 'Failed to fetch HWCs';
} else {
    $query = "SELECT DISTINCT district FROM yoga_instructors";
    $error_message = 'Failed to fetch districts';
}

$result = mysqli_query($conn, $query);

if (!$result) {
    http_response_code(500);
    echo json_encode(['error' => $error_message]);
    exit();
}

$data = array();
while ($row = mysqli_fetch_assoc($result)) {
    if (isset($row['district'])) {
        $data[] = $row['district'];
    } elseif (isset($row['ayush_hwc'])) {
        $data[] = $row['ayush_hwc'];
    }
}

echo json_encode($data);
?>
