<?php
require 'db.php';

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['id'])) {
    $sessionId = intval($_GET['id']); // Ensure sessionId is an integer

    if ($sessionId <= 0) {
        http_response_code(400);
        echo json_encode(["message" => "Invalid session ID"]);
        exit();
    }

    $sql = "SELECT s.id, s.session_name, s.time_slot, s.session_date, s.session_type, s.include_iec_activity, s.batch_type, s.batch_frequency, s.participant_number, s.session_status,
            SUM(CASE WHEN p.age < 16 THEN 1 ELSE 0 END) as below_16_years,
            SUM(CASE WHEN p.age >= 16 AND p.age <= 60 THEN 1 ELSE 0 END) as between_16_to_60_years,
            SUM(CASE WHEN p.age > 60 THEN 1 ELSE 0 END) as above_60_years,
            SUM(CASE WHEN p.gender = 'Male' THEN 1 ELSE 0 END) as male_count,
            SUM(CASE WHEN p.gender = 'Female' THEN 1 ELSE 0 END) as female_count,
            SUM(CASE WHEN p.gender = 'Other' THEN 1 ELSE 0 END) as other_count
            FROM yog_sessions s
            LEFT JOIN participants p ON s.id = p.session_id
            WHERE s.id = ?
            GROUP BY s.id";

    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(["message" => "Database prepare error: " . $conn->error]);
        exit();
    }

    $stmt->bind_param('i', $sessionId);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $session = $result->fetch_assoc();
            $session['include_iec_activity'] = $session['include_iec_activity'] ? 'Yes' : 'No';

            $participantSql = "SELECT name, mobile, age, gender FROM participants WHERE session_id = ?";
            $participantStmt = $conn->prepare($participantSql);
            if ($participantStmt === false) {
                http_response_code(500);
                echo json_encode(["message" => "Database prepare error: " . $conn->error]);
                exit();
            }

            $participantStmt->bind_param('i', $sessionId);
            if ($participantStmt->execute()) {
                $participantResult = $participantStmt->get_result();
                $participants = [];
                while ($participant = $participantResult->fetch_assoc()) {
                    $participants[] = $participant;
                }
                $session['participants'] = $participants;
            } else {
                http_response_code(500);
                echo json_encode(["message" => "Error fetching participants: " . $participantStmt->error]);
                exit();
            }

            echo json_encode($session);
        } else {
            http_response_code(404);
            echo json_encode(["message" => "Session not found"]);
        }
        $result->free();
    } else {
        http_response_code(500);
        echo json_encode(["message" => "Error fetching session: " . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
    exit();
}

http_response_code(400);
echo json_encode(["message" => "Invalid request"]);
?>
