<?php
require 'db.php';

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

$mobileNumber = isset($_GET['mobile_number']) ? $_GET['mobile_number'] : '';

if (empty($mobileNumber)) {
    echo json_encode(["message" => "Mobile number is required"]);
    http_response_code(400);
    exit();
}

// Debug: Log the received mobile number
error_log("Received mobile number: $mobileNumber");

// Retrieve the instructor ID based on the mobile number
$instructorQuery = "SELECT id FROM yoga_instructors WHERE mobile_number = ?";
$stmt = $conn->prepare($instructorQuery);
$stmt->bind_param("s", $mobileNumber);
$stmt->execute();
$instructorResult = $stmt->get_result();

if ($instructorResult->num_rows === 0) {
    echo json_encode(["message" => "Instructor not found"]);
    http_response_code(404);
    exit();
}

$instructor = $instructorResult->fetch_assoc();
$instructorId = $instructor['id'];

$stmt->close();

// Debug: Check if the correct instructor ID is retrieved
error_log("Instructor ID: $instructorId");

// Retrieve sessions for the instructor
$sql = "SELECT s.id, s.session_name, s.time_slot, s.created_at, s.session_status, s.session_type, s.include_iec_activity, s.participant_number, s.session_date, 
               GROUP_CONCAT(p.name) as participant_names, 
               GROUP_CONCAT(p.mobile) as participant_mobiles, 
               GROUP_CONCAT(p.age) as participant_ages, 
               GROUP_CONCAT(p.gender) as participant_genders 
        FROM yog_sessions s 
        LEFT JOIN participants p ON s.id = p.session_id 
        WHERE s.yoga_instructor_id = ?
        GROUP BY s.id";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $instructorId);
$stmt->execute();
$result = $stmt->get_result();

// Debug: Check the SQL query
error_log("SQL Query executed: $sql with Instructor ID: $instructorId");

$sessions = array();

if ($result) {
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $row['include_iec_activity'] = $row['include_iec_activity'] ? 'Yes' : 'No';
            $row['participants'] = [];
            
            if ($row['participant_names']) {
                $names = explode(',', $row['participant_names']);
                $mobiles = explode(',', $row['participant_mobiles']);
                $ages = explode(',', $row['participant_ages']);
                $genders = explode(',', $row['participant_genders']);
                
                for ($i = 0; $i < count($names); $i++) {
                    $row['participants'][] = [
                        'name' => $names[$i],
                        'mobile' => $mobiles[$i],
                        'age' => $ages[$i],
                        'gender' => $genders[$i]
                    ];
                }
            }
            
            unset($row['participant_names']);
            unset($row['participant_mobiles']);
            unset($row['participant_ages']);
            unset($row['participant_genders']);
            
            $sessions[] = $row;
        }
    }
    echo json_encode($sessions);
} else {
    echo json_encode(["message" => "Error executing query: " . $conn->error]);
}

$stmt->close();
$conn->close();
?>
