<?php

require __DIR__ . '/db.php';

function checkInput($input) 
{
    $input = trim($input);
    $input = stripslashes($input);
    $input = htmlspecialchars($input);
    return $input;
}

$mobile1 = '9582594165';
$mobileregex = "/^[2-9][0-9]{9}$/";

if(!preg_match($mobileregex, $mobile1)) 
{
    echo "You are not authorized for login";
    exit;
}

function generateNumericOTP($n) 
{ 
    $generator = "1357902468"; 
    $result = ""; 
    for ($i = 1; $i <= $n; $i++) 
    { 
        $result .= substr($generator, (rand() % (strlen($generator))), 1); 
    } 
    return $result;
} 

$n = 6; 
$otp = generateNumericOTP($n);

date_default_timezone_set('Asia/Kolkata');
$currentDateTime = date('Y-m-d h:i:s');

// Inserting data into the database
$qry = "INSERT INTO users (mobile, otp, created_at) VALUES ('$mobile1', '$otp', '$currentDateTime')";
$run = mysqli_query($conn, $qry);

if (!$run) {
    die("Database insert failed: " . mysqli_error($conn));
}

function post_to_url($url, $data) 
{
    $fields = http_build_query($data);
    $post = curl_init();
    curl_setopt($post, CURLOPT_SSLVERSION, 6);
    curl_setopt($post, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($post, CURLOPT_URL, $url);
    curl_setopt($post, CURLOPT_POST, true);
    curl_setopt($post, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($post, CURLOPT_RETURNTRANSFER, 1);
    $result = curl_exec($post); //result from mobile seva server
    curl_close($post); 
    return $result;
}

function sendSingleSMS($username, $encryp_password, $senderid, $message, $mobileno, $deptSecureKey, $templateid)
{
    $key = hash('sha512', trim($username) . trim($senderid) . trim($message) . trim($deptSecureKey));
    $data = array(
        "username" => trim($username),
        "password" => trim($encryp_password),
        "senderid" => trim($senderid),
        "content" => trim($message),
        "smsservicetype" => "singlemsg",
        "mobileno" => trim($mobileno),
        "key" => trim($key),
        "templateid" => trim($templateid)
    );
    return post_to_url("https://msdgweb.mgov.gov.in/esms/sendsmsrequestDLT", $data); //calling post_to_url to send sms
}

$username = "dogrpunjab-nhm"; //username of the department
$password = "ITcellnhm@38"; //password of the department
$senderid = "PBGOVT"; //senderid of the department
$message = "Your OTP to Login is " . $otp . ", Department of Health and Family Welfare, Punjab."; //message content
$deptSecureKey = "259ba52f-0bd1-4cfd-8efe-e6c025d92432"; //departsecure key
$encryp_password = sha1(trim($password));
$templateid = "1407165217487480024";

$response = sendSingleSMS($username, $encryp_password, $senderid, $message, $mobile1, $deptSecureKey, $templateid);
echo $response;

?>

