<?php
require 'db.php';

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);

if (isset($input['session_id']) && isset($input['asanas'])) {
    $session_id = $input['session_id'];
    $asanas = json_encode($input['asanas']); // Convert asanas array to JSON string

    // Check if session_id already exists
    $check_stmt = $conn->prepare("SELECT id FROM yog_sessions WHERE id = ?");
    $check_stmt->bind_param("s", $session_id);
    $check_stmt->execute();
    $check_stmt->store_result();

    if ($check_stmt->num_rows > 0) {
        // session_id exists, update the asanas field
        $update_stmt = $conn->prepare("UPDATE yog_sessions SET asanas = ? WHERE id = ?");
        $update_stmt->bind_param("ss", $asanas, $session_id);
        $update_stmt->execute();
        $update_stmt->close();

        echo json_encode(['status' => 'success', 'message' => 'Asanas updated successfully']);
    } else {
        // session_id does not exist, insert new record
        $insert_stmt = $conn->prepare("INSERT INTO yog_sessions (id, asanas) VALUES (?, ?)");
        $insert_stmt->bind_param("ss", $session_id, $asanas);
        $insert_stmt->execute();
        $insert_stmt->close();

        echo json_encode(['status' => 'success', 'message' => 'Asanas saved successfully']);
    }

    $check_stmt->close();
    $conn->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid input']);
}
?>
