<?php
header('Content-Type: application/json');
include 'db.php'; // Include your database connection file

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $session_id = $_POST['session_id'];
    $participant_number = $_POST['participant_number'];
    $session_date = $_POST['session_date'];
    $below_16_years = $_POST['Below_16_years'];
    $between_16_to_60_years = $_POST['Between_16_to_60_years'];
    $above_60_years = $_POST['Above_60_years'];
    $male = $_POST['Male'];
    $female = $_POST['Female'];
    $transgender = $_POST['Transgender'];
    $session_image = $_POST['Session_Image'];
    $capture_live_location = $_POST['Capture_Live_Location'];
    $status = $_POST['status'];

    // Validate and sanitize inputs
    // TODO: Add validation and sanitization code

    // Check if the session is already complete
    $check_query = "SELECT status FROM yog_sessions WHERE session_id = ?";
    $stmt = $conn->prepare($check_query);
    $stmt->bind_param("s", $session_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    if ($row && $row['status'] == 'complete') {
        echo json_encode(['status' => 'error', 'message' => 'Cannot edit a completed session']);
        exit;
    }

    // Insert or update session details
    $query = "INSERT INTO yog_sessions (
        session_id,
        participant_number,
        session_date,
        Below_16_years,
        Between_16_to_60_years,
        Above_60_years,
        Male,
        Female,
        Transgender,
        Session_Image,
        Capture_Live_Location,
        status
    ) VALUES (
        ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
    ) ON DUPLICATE KEY UPDATE 
        participant_number = VALUES(participant_number),
        session_date = VALUES(session_date),
        Below_16_years = VALUES(Below_16_years),
        Between_16_to_60_years = VALUES(Between_16_to_60_years),
        Above_60_years = VALUES(Above_60_years),
        Male = VALUES(Male),
        Female = VALUES(Female),
        Transgender = VALUES(Transgender),
        Session_Image = VALUES(Session_Image),
        Capture_Live_Location = VALUES(Capture_Live_Location),
        status = VALUES(status)";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssssssssssss", 
        $session_id, $participant_number, $session_date, 
        $below_16_years, $between_16_to_60_years, $above_60_years, 
        $male, $female, $transgender, $session_image, 
        $capture_live_location, $status);
    
    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Session details saved successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to save session details']);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>
