<?php
require 'db.php';
date_default_timezone_set('Asia/Kolkata'); 

function logMessage($message) {
    error_log($message, 3, 'otp_sending.log');
}

function generateOTP($length = 6) {
    $otp = '';
    for ($i = 0; $i < $length; $i++) {
        $otp .= rand(0, 9);
    }
    return $otp;
}

function post_to_url($url, $data) {
    $fields = '';
    foreach ($data as $key => $value) {
        $fields .= $key . '=' . $value . '&';
    }
    rtrim($fields, '&');
    $post = curl_init();
    curl_setopt($post, CURLOPT_SSLVERSION, 6);
    curl_setopt($post, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($post, CURLOPT_URL, $url);
    curl_setopt($post, CURLOPT_POST, count($data));
    curl_setopt($post, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($post, CURLOPT_RETURNTRANSFER, 1);
    $result = curl_exec($post); // result from SMS server
    curl_close($post);
    return $result;
}

function sendSingleSMS($username, $encryp_password, $senderid, $message, $mobileno, $deptSecureKey, $templateid) {
    $key = hash('sha512', trim($username) . trim($senderid) . trim($message) . trim($deptSecureKey));
    $data = array(
        "username" => trim($username),
        "password" => trim($encryp_password),
        "senderid" => trim($senderid),
        "content" => trim($message),
        "smsservicetype" => "singlemsg",
        "mobileno" => trim($mobileno),
        "key" => trim($key),
        "templateid" => trim($templateid)
    );
    return post_to_url("https://msdgweb.mgov.gov.in/esms/sendsmsrequestDLT", $data); // calling post_to_url to send SMS
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $mobile = $_POST['mobile'];
    logMessage("Received request to send OTP to mobile: $mobile\n");

    // Validate mobile number
    if (!preg_match("/^[2-9][0-9]{9}$/", $mobile)) {
        logMessage("Invalid mobile number: $mobile\n");
        echo json_encode(['success' => false, 'message' => 'Invalid mobile number']);
        exit;
    }

    // Check if the mobile number exists in the yoga_instructors table
    $stmt = $conn->prepare("SELECT * FROM yoga_instructors WHERE mobile_number = ?");
    if ($stmt === false) {
        logMessage("Prepare failed: (" . $conn->errno . ") " . $conn->error . "\n");
        die(json_encode(['success' => false, 'message' => 'Database error']));
    }
    
    $stmt->bind_param("s", $mobile);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();

    if (!$user) {
        logMessage("Mobile number not registered: $mobile\n");
        echo json_encode(['success' => false, 'message' => 'Mobile number not registered']);
        exit;
    }

    $otp = generateOTP();
    $otpCreatedAt = date('Y-m-d H:i:s');

    // Insert OTP into database
    $stmt = $conn->prepare("INSERT INTO generate_otp (mobile, otp_value, otp_dateTime, flag) VALUES (?, ?, ?, 0)");
    if ($stmt === false) {
        logMessage("Prepare failed: (" . $conn->errno . ") " . $conn->error . "\n");
        die(json_encode(['success' => false, 'message' => 'Database error']));
    }
    
    $stmt->bind_param("sss", $mobile, $otp, $otpCreatedAt);
    if ($stmt->execute() === false) {
        logMessage("Execute failed: (" . $stmt->errno . ") " . $stmt->error . "\n");
        die(json_encode(['success' => false, 'message' => 'Database error']));
    }
    $stmt->close();
    logMessage("Inserted OTP into database for mobile: $mobile with OTP: $otp\n");

    // Prepare SMS details
    $username = "dogrpunjab-nhm";
    $password = "ITcellnhm@38";
    $senderid = "PBGOVT";
    $message = "Your OTP to Login is " . $otp . ", Department of Health and Family Welfare, Punjab.";
    $deptSecureKey = "259ba52f-0bd1-4cfd-8efe-e6c025d92432";
    $encryp_password = sha1(trim($password));
    $templateid = "1407165217487480024";

    // Send SMS
    $smsResult = sendSingleSMS($username, $encryp_password, $senderid, $message, $mobile, $deptSecureKey, $templateid);
    logMessage("SMS result for mobile $mobile: $smsResult\n");
    if ($smsResult) {
        echo json_encode(['success' => true, 'message' => 'OTP sent successfully']);
        logMessage("Sent OTP successfully to mobile: $mobile\n");
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to send OTP']);
        logMessage("Failed to send OTP to mobile: $mobile\n");
    }
}
?>
