<?php
require 'db.php';

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$data = json_decode(file_get_contents("php://input"), true);

if (!$data || !isset($data['session_id']) || !isset($data['status'])) {
    echo json_encode(array("message" => "Invalid input"));
    exit;
}

$session_id = $data['session_id'];
$status = $data['status'];

$sql = "UPDATE yog_sessions SET session_status = ? WHERE id = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    echo json_encode(array("message" => "Database prepare error: " . $conn->error));
    exit;
}

$stmt->bind_param("si", $status, $session_id);

if ($stmt->execute()) {
    echo json_encode(array("message" => "Session status updated successfully"));
} else {
    echo json_encode(array("message" => "Failed to update session status: " . $stmt->error));
}

$stmt->close();
$conn->close();
?>
