<?php
require 'db.php';

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$target_dir = "uploads/";

if (!is_dir($target_dir)) {
    mkdir($target_dir, 0777, true);
}

if (isset($_FILES['image'])) {
    $file_name = basename($_FILES['image']['name']);
    $file_tmp_name = $_FILES['image']['tmp_name'];
    $file_size = $_FILES['image']['size'];
    $file_error = $_FILES['image']['error'];
    $file_type = $_FILES['image']['type'];
    
    // Validate file type
    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
    $allowed_ext = array("jpg", "jpeg", "png", "gif");

    if (!in_array($file_ext, $allowed_ext)) {
        echo json_encode(array("message" => "Invalid file type. Only JPG, JPEG, PNG, and GIF files are allowed."));
        exit;
    }

    // Check for upload errors
    if ($file_error !== UPLOAD_ERR_OK) {
        echo json_encode(array("message" => "Failed to upload image. Error code: " . $file_error));
        exit;
    }

    // Generate a unique file name to prevent overwriting
    $unique_file_name = uniqid('', true) . "." . $file_ext;
    $target_file = $target_dir . $unique_file_name;

    // Move uploaded file to target directory
    if (move_uploaded_file($file_tmp_name, $target_file)) {
        echo json_encode(array("imageUrl" => $target_file));
    } else {
        echo json_encode(array("message" => "Failed to upload image"));
    }
} else {
    echo json_encode(array("message" => "No image file provided"));
}
?>
