<?php
require 'db.php';

function logMessage($message) {
    error_log($message, 3, 'otp_verification.log');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $mobile = $_POST['mobile'];
    $otp = $_POST['otp'];

    logMessage("Received verification request for mobile: $mobile with OTP: $otp\n");

    // Fetch the most recent OTP from database
    $stmt = $conn->prepare("SELECT otp_value, otp_dateTime FROM generate_otp WHERE mobile = ? AND flag = 0 ORDER BY otp_dateTime DESC LIMIT 1");
    if ($stmt === false) {
        logMessage("Prepare failed: (" . $conn->errno . ") " . $conn->error . "\n");
        die(json_encode(['success' => false, 'message' => 'Database error']));
    }
    
    $stmt->bind_param("s", $mobile);
    $stmt->execute();
    $stmt->bind_result($dbOtp, $otpCreatedAt);
    if (!$stmt->fetch()) {
        $stmt->close();
        echo json_encode(['success' => false, 'message' => 'Invalid OTP']);
        logMessage("Invalid OTP - No record found\n");
        exit;
    }
    $stmt->close();

    logMessage("Fetched OTP from database: $dbOtp created at: $otpCreatedAt\n");

    if ((string)$dbOtp === (string)$otp) {
        $otpAge = (strtotime(date('Y-m-d H:i:s')) - strtotime($otpCreatedAt)) / 60;
        logMessage("OTP age: $otpAge minutes\n");
        if ($otpAge <= 10) { // OTP valid for 10 minutes
            // Mark OTP as used
            $updateStmt = $conn->prepare("UPDATE generate_otp SET flag = 1 WHERE mobile = ?");
            if ($updateStmt === false) {
                logMessage("Prepare failed: (" . $conn->errno . ") " . $conn->error . "\n");
                die(json_encode(['success' => false, 'message' => 'Database error']));
            }
            $updateStmt->bind_param("s", $mobile);
            if ($updateStmt->execute() === false) {
                logMessage("Execute failed: (" . $updateStmt->errno . ") " . $updateStmt->error . "\n");
                die(json_encode(['success' => false, 'message' => 'Database error']));
            }
            $updateStmt->close();

            // Fetch instructor details
            $stmt = $conn->prepare("SELECT instructor_name, district, ayush_hwc FROM yoga_instructors WHERE mobile_number = ?");
            if ($stmt === false) {
                logMessage("Prepare failed: (" . $conn->errno . ") " . $conn->error . "\n");
                die(json_encode(['success' => false, 'message' => 'Database error']));
            }

            $stmt->bind_param("s", $mobile);
            $stmt->execute();
            $result = $stmt->get_result();
            $instructor = $result->fetch_assoc();
            $stmt->close();

            if (!$instructor) {
                echo json_encode(['success' => false, 'message' => 'Instructor not found']);
                logMessage("Instructor not found\n");
                exit;
            }

            echo json_encode([
                'success' => true,
                'message' => 'OTP verified successfully',
                'name' => $instructor['instructor_name'],
                'district' => $instructor['district'],
                'ayush_hwc' => $instructor['ayush_hwc']
            ]);
            logMessage("OTP verified successfully and instructor details fetched\n");
        } else {
            echo json_encode(['success' => false, 'message' => 'OTP expired']);
            logMessage("OTP expired\n");
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid OTP']);
        logMessage("Invalid OTP\n");
    }
}
?>
