<?php
header('Content-Type: application/json');
include 'db.php'; // Include your database connection file

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$data = json_decode(file_get_contents("php://input"), true);
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($data['action']) && $data['action'] == 'add_participant') {
        // Adding a participant
        $sessionId = $data['session_id'];
        $name = $data['name'];
        $mobile = $data['mobile'];
        $age = $data['age'];
        $gender = $data['gender'];

        // Insert participant details
        $sql = "INSERT INTO participants (session_id, name, mobile, age, gender) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("issis", $sessionId, $name, $mobile, $age, $gender);
        $stmt->execute();
        $stmt->close();

        // Update participant count and session details
        $sql = "UPDATE yog_sessions 
                SET participant_number = participant_number + 1,
                    Below_16_years = Below_16_years + IF(? < 16, 1, 0),
                    Between_16_to_60_years = Between_16_to_60_years + IF(? BETWEEN 16 AND 60, 1, 0),
                    Above_60_years = Above_60_years + IF(? > 60, 1, 0),
                    Male = Male + IF(? = 'Male', 1, 0),
                    Female = Female + IF(? = 'Female', 1, 0),
                    Transgender = Transgender + IF(? = 'Transgender', 1, 0),
                    gender_data = JSON_ARRAY_APPEND(gender_data, '$', JSON_OBJECT('age', ?, 'gender', ?))
                WHERE session_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iiiiiiiiiss", $age, $age, $age, $age, $gender, $gender, $age, $gender, $sessionId);
        $stmt->execute();
        $stmt->close();

        // Check if the session should be marked as complete
        $sql = "SELECT participant_number FROM yog_sessions WHERE session_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $sessionId);
        $stmt->execute();
        $stmt->bind_result($participantNumber);
        $stmt->fetch();
        $stmt->close();

        $newStatus = $participantNumber < 10 ? 'Not Complete' : 'Complete';
        $sql = "UPDATE yog_sessions SET status = ? WHERE session_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $newStatus, $sessionId);
        $stmt->execute();
        $stmt->close();

        echo json_encode(['status' => 'success']);
    } else {
        // Saving session details
        $session_id = $data['session_id'];
        $participant_number = $data['participant_number'];
        $below_16_years = $data['Below_16_years'];
        $between_16_to_60_years = $data['Between_16_to_60_years'];
        $above_60_years = $data['Above_60_years'];
        $male = $data['Male'];
        $female = $data['Female'];
        $transgender = $data['Transgender'];
        $session_image = $data['Session_Image'];
        $capture_live_location = $data['Capture_Live_Location'];
        $status = $data['status'];

        // Validate and sanitize inputs
        // TODO: Add validation and sanitization code

        // Check if the session is already complete
        $check_query = "SELECT status FROM yog_sessions WHERE session_id = ?";
        $stmt = $conn->prepare($check_query);
        $stmt->bind_param("s", $session_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        if ($row && $row['status'] == 'complete') {
            echo json_encode(['status' => 'error', 'message' => 'Cannot edit a completed session']);
            exit;
        }

        // Insert or update session details
        $query = "INSERT INTO yog_sessions (
            session_id,
            participant_number,
            Below_16_years,
            Between_16_to_60_years,
            Above_60_years,
            Male,
            Female,
            Transgender,
            Session_Image,
            Capture_Live_Location,
            status
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
        ) ON DUPLICATE KEY UPDATE 
            participant_number = VALUES(participant_number),
            Below_16_years = VALUES(Below_16_years),
            Between_16_to_60_years = VALUES(Between_16_to_60_years),
            Above_60_years = VALUES(Above_60_years),
            Male = VALUES(Male),
            Female = VALUES(Female),
            Transgender = VALUES(Transgender),
            Session_Image = VALUES(Session_Image),
            Capture_Live_Location = VALUES(Capture_Live_Location),
            status = VALUES(status)";

        $stmt = $conn->prepare($query);
        $stmt->bind_param("sssssssssss", 
            $session_id, $participant_number, 
            $below_16_years, $between_16_to_60_years, $above_60_years, 
            $male, $female, $transgender, $session_image, 
            $capture_live_location, $status);
        
        if ($stmt->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'Session details saved successfully']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to save session details']);
        }

        $stmt->close();
        $conn->close();
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>
